#version 330
#extension GL_EXT_gpu_shader4 : enable
//2D Dual Vector Distance EstimateMod01.fsh by skye_adaire
//https://www.shadertoy.com/view/Wsc3D4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Created by Skye Adaire

#define pi32 3.1415926535
#define tau32 6.2831853072
#define eps32 10e-15

#define Real float
#define Nat uint

Real H_negate(Real r)
{
    return -r;
}

Real H_conjugate(Real r)
{
    return r;
}

Real H_norm(Real r)
{
    return abs(r);
}

Real H_sqnorm(Real r)
{
    return r * r;
}

Real H_inverse(Real r)
{
 	return 1.0 / r;   
}

Real H_add(Real lhs, Real rhs)
{
    return lhs + rhs;
}

Real H_subtract(Real lhs, Real rhs)
{
    return lhs - rhs;
}

Real H_multiply(Real lhs, Real rhs)
{
    return lhs * rhs;
}

Real H_divide(Real lhs, Real rhs)
{
    return lhs / rhs;
}

bool H_isZero(Real r)
{
    return H_norm(r) < eps32;
}

Real H_power(Real x, Real e)
{
    return pow(x, e);
}

Real H_power(Real x, Nat e)
{
    return pow(abs(x), float(e)) * ((e % 2u) == 0u ? 1.0 : sign(x));
}

Real H_sq(Real r)
{
    return r * r;
}

Real H_sin(Real r)
{
    return sin(r);
}

Real H_cos(Real r)
{
    return cos(r);
}

#define DualReal vec2

DualReal D_add(DualReal lhs, DualReal rhs)
{
    return lhs + rhs;
}

DualReal D_subtract(DualReal lhs, DualReal rhs)
{
    return lhs - rhs;
}

DualReal D_multiply(DualReal lhs, DualReal rhs)
{
    return DualReal(
        H_multiply(lhs[0], rhs[0]),
        H_add(H_multiply(lhs[1], rhs[0]), H_multiply(lhs[0], rhs[1])));
}

DualReal D_divide(DualReal lhs, DualReal rhs)
{
    return DualReal(
        H_divide(rhs[0], lhs[0]),
        H_divide(
            H_subtract(H_multiply(lhs[1], rhs[0]), H_multiply(lhs[0], rhs[1])),
            H_sq(rhs[0])));
}

DualReal D_power(DualReal d, Real exponent)
{
    return DualReal(
        H_power(d[0], exponent),
        H_multiply(exponent * H_power(d[0], exponent - 1.0), d[1]));
}

DualReal D_power(DualReal d, Nat exponent)
{
    return DualReal(
        H_power(d[0], exponent),
        H_multiply(float(exponent) * H_power(d[0], exponent - 1u), d[1]));
}

DualReal D_sq(DualReal d)
{
 	return D_multiply(d, d);   
}

DualReal D_inverse(DualReal d)
{
    return DualReal(
        H_inverse(d[0]),
        H_multiply(H_negate(H_inverse(H_sq(d[0]))), d[1]));
}

DualReal D_sin(DualReal d)
{
 	return DualReal(
        H_sin(d[0]), 
        H_multiply(d[1], H_cos(d[0])));   
}
                          
DualReal D_cos(DualReal d)
{
 	return DualReal(
        H_cos(d[0]),
        H_multiply(H_negate(d[1]), H_sin(d[0])));   
}

#define DualVector2 mat2x2

//end Hypercomplex

DualReal f(DualVector2 d)
{
    DualReal a = DualReal(cos(iTime) * 4.0, 0);
    DualReal s = DualReal(sin(iTime * pi32 * 0.2)*0.4 + 0.6, 0);
    
    return d[1] - D_multiply(D_cos(D_multiply(d[0], s)), a);
    
    
    
    return D_multiply(D_sq(d[0]), a) + D_sq(d[1]) - DualReal(1, 0);
}	

float getDE(vec2 p, out vec2 gradient)
{
 	DualReal dx = f(DualVector2(p.x, 1, p.y, 0)); 
    DualReal dy = f(DualVector2(p.x, 0, p.y, 1));
    
    float fp = dx[0];//level, same for both partials
    gradient = vec2(dx[1], dy[1]);
   
    return fp / length(gradient);
}

vec3 getColor(vec2 p)
{
    vec2 gradient;
    float de = getDE(p, gradient);
    
    vec3 normal = normalize(vec3(gradient, 0));
    float curve = 1.0 - smoothstep(0.19, 0.2, abs(de));
    
    vec3 color = vec3(0);  
    vec3 colorNegative = vec3(1,0.8,0.8);
    vec3 colorPositive = vec3(0.8,1,0.8);
    vec3 background = vec3(fract(de));
    if (de < 0.0) background = 1.0 - background;
    background *= 0.7;
    
    color = mix(background, normal, curve);
    
    return color;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
     vec2 uv = gl_FragCoord.xy/iResolution.xy;
    vec2 clip = uv * 2.0 - 1.0;
   	clip.x *= iResolution.x / iResolution.y;
    vec2 p = clip * 6.0;

    // Output to screen
    gl_FragColor = vec4(getColor(p),1.0);
}